/*------------------------------------------------------------------------------*
 * File Name: DefVarWizDlg.h													*
 * Creation: Kyle 06/17/2009													*
 * Purpose: OriginC Source file													*
 * Copyright (c) OriginLab Corp. 2009											*
 * All Rights Reserved															*
 *																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef __DEFINE_VAR_WIZ__
#define __DEFINE_VAR_WIZ__

#include <Origin.h>
#include "DialogEx.h"

/*----------------------------------------------------------------------------*/
/* Macros/Enums
/*----------------------------------------------------------------------------*/

#define DEFAULT_VAR_NAME						"myvar"

enum
{
	VAR_TYPE_RANGE,
	VAR_TYPE_PAGE_INFO,
};

/*----------------------------------------------------------------------------*/
/* DefVarPropertyPage
/*----------------------------------------------------------------------------*/

class DefVarPropertyPage : public PropertyPage
{
public:
	DefVarPropertyPage(int nID) : PropertyPage(nID)
	{
		m_pWizardSheet = NULL;
	}
	virtual void InitPage(int nID, WizardSheet* pWizardSheet)
	{
		SetID(nID);
		m_pWizardSheet = pWizardSheet;
	}
protected:
	WizardSheet*	m_pWizardSheet;
};

/*----------------------------------------------------------------------------*/
/* DefVarTypePage
/*----------------------------------------------------------------------------*/

#define IDC_DEF_VAR_TYPE_RADIO_FIRST		IDC_DEF_VAR_TYPE_RANGE
#define IDC_DEF_VAR_TYPE_RADIO_LAST			IDC_DEF_VAR_TYPE_PAGE_INFO

class DefVarTypePage : public DefVarPropertyPage
{
public:

	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
	EVENTS_END

	BOOL OnInitPage()
	{
		int nIDToBeCheckedBtn;
		if (VAR_TYPE_RANGE == m_nVarType)
			nIDToBeCheckedBtn = IDC_DEF_VAR_TYPE_RANGE;
		else if (VAR_TYPE_PAGE_INFO == m_nVarType)
			nIDToBeCheckedBtn = IDC_DEF_VAR_TYPE_PAGE_INFO;
		CheckRadioButton(IDC_DEF_VAR_TYPE_RADIO_FIRST, IDC_DEF_VAR_TYPE_RADIO_LAST, nIDToBeCheckedBtn);
		return TRUE;
	}

	BOOL OnActivatePage()
	{
		return TRUE;		
	}
	BOOL OnKillActiviePage()
	{
		const int nCheckedRadioBtnID = GetCheckedRadioButton(IDC_DEF_VAR_TYPE_RADIO_FIRST, IDC_DEF_VAR_TYPE_RADIO_LAST);
		if (IDC_DEF_VAR_TYPE_RANGE == nCheckedRadioBtnID)
			m_nVarType = VAR_TYPE_RANGE;
		else if (IDC_DEF_VAR_TYPE_PAGE_INFO == nCheckedRadioBtnID)
			m_nVarType = VAR_TYPE_PAGE_INFO;
		return TRUE;
	}
	
	void SetVarType(int nVarType)
	{
		m_nVarType = nVarType;
	}
	
	int	GetVarType()
	{
		return m_nVarType;
	}

private:
	WizardSheet*	m_pWizardSheet;
	int 			m_nVarType;
};

/*----------------------------------------------------------------------------*/
/* DefVarNamePage
/*----------------------------------------------------------------------------*/

class DefVarNamePage : public DefVarPropertyPage
{
public:

	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitPage)
		PAGE_ON_ACTIVE(OnActivatePage)
		PAGE_ON_KILLACTIVE(OnKillActiviePage)
		ON_EN_CHANGE(IDC_DEF_VAR_NAME, OnEditChangeVarName)
	EVENTS_END

	BOOL OnInitPage()
	{
		m_edVarName = GetItem(IDC_DEF_VAR_NAME);
		m_edVarName.Text = m_strVarName;
		return TRUE;
	}

	BOOL OnActivatePage()
	{
		return TRUE;		
	}
	BOOL OnKillActiviePage()
	{
		m_strVarName = m_edVarName.Text;
		return TRUE;
	}

	BOOL OnEditChangeVarName(Control ctrl)
	{
		string strVarName = m_edVarName.Text;
		if (m_pWizardSheet)
		{
			m_pWizardSheet->EnableFinishButton( !strVarName.IsEmpty() && is_good_C_identifier(strVarName) );
		}
		return TRUE;
	}

	void SetVarName(LPCSTR lpcszDefaultName)
	{
		m_strVarName = lpcszDefaultName;
	}

	string GetVarName()
	{
		return m_strVarName;
	}
private:
	Edit		m_edVarName;
	string 		m_strVarName;
};

/*----------------------------------------------------------------------------*/
/* DefVarWizSheet
/*----------------------------------------------------------------------------*/

class DefVarWizSheet : public WizardSheet
{
public:
	DefVarWizSheet()
	{
		m_defVarType.InitPage(IDD_DEF_VAR_TYPE, this);
		AddPage(m_defVarType);
		m_defVarName.InitPage(IDD_DEF_VAR_NAME, this);
		AddPage(m_defVarName);
	}

	void InitMaps()
	{
		m_defVarType.InitMsgMap();
		m_defVarName.InitMsgMap();
	}

	void SetSettings(int nVarType, string strDefVarName)
	{
		m_nVarType = nVarType;
		m_strVarName = strDefVarName;

		m_defVarType.SetVarType(m_nVarType);
		m_defVarName.SetVarName(m_strVarName);
	}

	void GetSettings(int& nVarType, string& strVarName)
	{
		m_nVarType = m_defVarType.GetVarType();
		m_strVarName = m_defVarName.GetVarName();

		nVarType = m_nVarType;
		strVarName = m_strVarName;
	}
private:
	DefVarTypePage	m_defVarType;
	DefVarNamePage	m_defVarName;

	int 			m_nVarType;
	string 			m_strVarName;
};

/*----------------------------------------------------------------------------*/
/* DefVarWizDlg
/*----------------------------------------------------------------------------*/

class DefVarWizDlg : public Dialog
{
public:
	DefVarWizDlg() : Dialog(IDD_DEF_VAR_DLG, "Odlg8")
	{
		m_nVarType = 0;
		m_strVarName = "";
	}
	
	int DoModalEx(HWND hParent, int nVarType, LPCSTR lpcszVarName)
	{
		m_nVarType = nVarType;
		m_strVarName = lpcszVarName;
		InitMsgMap();

		int nRet = Dialog::DoModal(hParent, DLG_TITLE_TO_HAVE_PAGE_NAME);
		return nRet;
	}

	void GetSettings(int& nVarType, string& strVarName)
	{
		m_PlaceHolder.GetSettings(m_nVarType, m_strVarName);
		nVarType = m_nVarType;
		strVarName = m_strVarName;
	}
protected:
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitDialog)
		PAGE_ON_FINISH(OnFinish)
		PAGE_ON_CANCEL(OnCancel)
	EVENTS_END

	BOOL OnInitDialog()
	{
		m_PlaceHolder.SetSettings(m_nVarType, m_strVarName);
		m_PlaceHolder.Create(IDC_PAGE_PLACEHOLDER, *this);
		m_PlaceHolder.InitMaps();
		return TRUE;
	}

	BOOL OnFinish()
	{
		m_PlaceHolder.GetSettings(m_nVarType, m_strVarName);
		return TRUE;
	}
	
	BOOL OnCancel()
	{
		return TRUE;
	}
	
private:
	DefVarWizSheet 	m_PlaceHolder;

	int 			m_nVarType;
	string 			m_strVarName;
};

/*----------------------------------------------------------------------------*/
/* Interfaces
/*----------------------------------------------------------------------------*/

typedef BOOL (*PFN_OPEN_COLUMN_BROWSER) (string& strSel, int nType, bool bName, HWND hParent, LPCSTR lpcszWks);

static bool _open_column_browser(string& strCol, int nPageType, bool bShortName = true, HWND hParent = NULL, LPCSTR lpcszWks = NULL)
{
	PFN_OPEN_COLUMN_BROWSER pfn = Project.FindFunction("OpenColumnBrowser", "OriginLab\\ColumnBrowser.c");

	return ( pfn && pfn(strCol, nPageType, bShortName, hParent, lpcszWks) );
}

typedef bool (*PFN_INSERT_USER_VAR) (HWND hWndParent, string& str, int* lpType = NULL, bool bEnableInsertAsLinkBtn = true);

static bool _open_insert_info_variables_dlg(string& strVal, HWND hParent = NULL, int* lpType = NULL, bool bEnableInsertAsLinkBtn = true)
{
	PFN_INSERT_USER_VAR pfn = Project.FindFunction("InsertUserVar", "OriginLab\\InsertUserVar", true);

	return ( pfn && pfn(hParent, strVal, lpType, bEnableInsertAsLinkBtn) );
}

bool DefVarWizopen(string& strScript, HWND hParent = NULL)
{
	DefVarWizDlg wizDlg;
	if(NULL == hParent)
		hParent=GetWindow();

	int nVarType = VAR_TYPE_RANGE;
	string strVarName = DEFAULT_VAR_NAME;
	string strVal;
	int nRet = wizDlg.DoModalEx( hParent, nVarType, strVarName );
	if(IDCANCEL != nRet)
	{
		wizDlg.GetSettings(nVarType, strVarName);
		switch(nVarType)
		{
		case VAR_TYPE_RANGE:
			{
				Layer lyActive = Project.ActiveLayer();
				string strLayerRange;
				if ( !lyActive || !lyActive.GetRangeString(strLayerRange) )
					return false;
				if ( !_open_column_browser(strVal, lyActive.GetPage().GetType(), true, hParent) )
					return false;
				strVal.TrimLeft();
				strScript.Format("range %s = %s%s;", strVarName, strLayerRange, strVal);
			}
			break;
			
		case VAR_TYPE_PAGE_INFO:
			strVal = "cell";
			if ( !_open_insert_info_variables_dlg(strVal, hParent, NULL, false) )
				return false;
			if ( strVal.IsEmpty() )
				return false;
			strVal.Replace("\n", "\\n");
			strScript.Format("string %s$ = \"%s\";", strVarName, strVal);
			break;
		}

		return true;
	}
	return false;
}
#endif //__DEFINE_VAR_WIZ__
